import os, json, argparse
import pandas as pd

def main():
    ap = argparse.ArgumentParser()
    ap.add_argument("--runs-dir", required=True)
    ap.add_argument("--out", required=True)
    args = ap.parse_args()

    rows = []
    for root, _, files in os.walk(args.runs_dir):
        for fn in files:
            if fn.endswith(".json"):
                with open(os.path.join(root, fn), "r") as f:
                    try:
                        rows.append(json.load(f))
                    except Exception:
                        pass
    if not rows:
        print("No rows to aggregate.")
        return
    df = pd.DataFrame(rows)
    os.makedirs(os.path.dirname(args.out), exist_ok=True)
    df.to_csv(args.out, index=False)
    print(f"Wrote {len(df)} rows -> {args.out}")

if __name__ == "__main__":
    main()
